<?php
/* --------------------------------------------------------------
   DataObserverFeature.inc.php 2020-02-21
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class DataObserverFeature
 *
 * @package    GXModules
 * @subpackage GambioHub
 */
class DataObserverFeature
{
	/**
	 * @var string
	 */
	const GLOBAL_CONFIGURATION_KEY = 'MODULE_PAYMENT_GAMBIO_HUB_DATA_OBSERVER';

	/**
	 * @var string
	 */
	const MODULE_CONFIGURATION_KEY = '%GAMBIO_HUB_REMOTE_CONFIG_%_ERPINTEGRATION%';


	/**
	 * Checks whether the data observer feature is active.
	 *
	 * The data observer is a rather resource consuming feature adding extra overhead to each request and should
	 * therefore only be executed, when it is really necessary. This method will check all the required cases that
	 * need to be met, before considering the feature as active.
	 *
	 * @return bool
	 */
	public static function isActive()
	{
		// Check if the global configuration value is true.
		if(!defined(self::GLOBAL_CONFIGURATION_KEY))
		{
			return false; // Do not process data changes if the data observer configuration entry is missing.
		}

		if(defined(self::GLOBAL_CONFIGURATION_KEY)
		   && !filter_var(@constant(self::GLOBAL_CONFIGURATION_KEY), FILTER_VALIDATE_BOOLEAN))
		{
			return false; // Do not process data changes if the data observer feature is inactive.
		}

		// Check if there is at least one Hub module that has the ERP integration feature on.
		$queryBuilder = StaticGXCoreLoader::getDatabaseQueryBuilder();

		$isLegacyConfiguration = $queryBuilder->table_exists('gx_configurations');

		$moduleConfigurationKey = $queryBuilder->escape($isLegacyConfiguration
            ? self::MODULE_CONFIGURATION_KEY
            : 'gm_configuration/' . self::MODULE_CONFIGURATION_KEY);

        if ($isLegacyConfiguration) {
            $erpIntegrationCount = $queryBuilder->where('`key` LIKE ' . $moduleConfigurationKey)
                                                ->where('`value` = "True"')
                                                ->get('gx_configurations')
                                                ->num_rows();
        } else {
            $erpIntegrationCount = $queryBuilder->where('gm_key LIKE ' . $moduleConfigurationKey)
                                                ->where('gm_value = "True"')
                                                ->get('gm_configuration')
                                                ->num_rows();
        }

        if($erpIntegrationCount === 0)
		{
			return false; // Do not process data changes if no Hub module is using the ERP integration feature.
		}

		return true;
	}
}
